// ==UserScript==
// @name         5ch 連続改行短縮
// @namespace    https://example.com/
// @version      1.3.0
// @description  post-content内の3連以上の<br>や空白を2つに制限（<br>＋空白も対応、表示領域で処理）
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';

    function isBrOrWhitespace(node) {
        return (
            (node.nodeType === 1 && node.tagName === 'BR') ||
            (node.nodeType === 3 && /^\s*$/.test(node.textContent))
        );
    }

    function collapseBrs(post) {
        if (post.dataset.brCollapsed) return;
        post.dataset.brCollapsed = 'true';

        const nodes = Array.from(post.childNodes);
        let buffer = [];
        let brCount = 0;

        for (let i = 0; i < nodes.length; i++) {
            const node = nodes[i];

            if (isBrOrWhitespace(node)) {
                buffer.push(node);
                if (node.nodeType === 1 && node.tagName === 'BR') brCount++;
            } else {
                if (brCount >= 3) {
                    let brKept = 0;
                    for (const n of buffer) {
                        if (n.nodeType === 1 && n.tagName === 'BR') {
                            brKept++;
                            if (brKept <= 2) continue;
                        }
                        n.remove(); // remove extra <br> and whitespace
                    }
                }
                // リセット
                buffer = [];
                brCount = 0;
            }
        }
    }

    const observer = new IntersectionObserver((entries, obs) => {
        for (const entry of entries) {
            if (entry.isIntersecting) {
                collapseBrs(entry.target);
                obs.unobserve(entry.target);
            }
        }
    });

    // 初期処理
    document.querySelectorAll('.post-content').forEach(el => observer.observe(el));

    // 動的追加にも対応
    const mo = new MutationObserver(mutations => {
        for (const m of mutations) {
            for (const node of m.addedNodes) {
                if (!(node instanceof HTMLElement)) continue;
                if (node.matches('.post-content')) {
                    observer.observe(node);
                } else {
                    node.querySelectorAll?.('.post-content').forEach(child => observer.observe(child));
                }
            }
        }
    });

    mo.observe(document.body, { childList: true, subtree: true });
})();
